Kerkerkruip Items by Victor Gijsbers begins here.



Book - Treasures

Chapter - Rules for placement


Section - Valuation

Valuation is a kind of value. The valuations are minor, major, epic, unique and non-treasure.
[The number of treasures of each valuation which is placed is set at the end of Dungeon Generation.]
[Valuation also determines how far from Entrance Hall a treasure will generally be found.]

A thing has a valuation. A thing is usually non-treasure.

A treasure scoring rule (this is the better treasures farther away rule):
	if considered treasure is major:
		increase current room score by distance of considered room;
	if considered treasure is epic:
		increase current room score by two times distance of considered room.

The verb to value (it values, they value, it is valuing) implies the valuation property.

Section - Mood

A thing has a mood. The mood of a thing is usually non-mood.
		
A treasure scoring rule (this is the mood rule):
	if mood of considered treasure is mood of considered room:
		increase current room score by 2;
	if mood of considered treasure is non-mood:
		say "BUG: forgot to set mood of [considered treasure].".

Chapter - Special kinds of treasure
		
Section - Treasure Packs

[Suppose we want to put three potions of X together as a treasure. First, we probably don't want to make all tokens of a type into placeable treasures. Second, how do we get three together? The solution to both is the treasure pack: a dummy item that gets placed, and is then turned into whatever it contains.]

A treasure pack is a kind of container.

Dungeon finish rule (this is the remove treasure packs rule):
	repeat with item running through treasure packs:
		if item is not off-stage:
			let X be a random thing that contains item;
			if the location of item contains item, let X be the location of item; 
			repeat with Y running through things contained by item:
				move Y to X;
			remove item from play.


Chapter - Kinds of Treasure

Section - Essences

An essence is a kind of thing. Understand "essence" and "small" and "metal" and "bottle" as an essence.
An essence is usually magical.
An essence is usually iron.

Inhaling is an action applying to one carried thing. Understand "inhale [thing]" as inhaling.
Does the player mean inhaling an essence: it is very likely.

Check inhaling:
	if the noun is not an essence:
		take no time;
		say "Only magical essences can be consumed through inhaling.".

First carry out inhaling:
	say "You uncork the little bottle and push its mouth deep into your [one of]left[or]right[at random] nostril, pressing the other side of your nose closed with your fingers. You inhale deeply -- and with a burning sensation, the magical essence flows up and into your brain.[run paragraph on]"

Last carry out inhaling:
	remove the noun from play.

Instead of opening an essence:
	take no time;
	say "The minute amount of magical essence would immediately evaporate and be lost forever. To use an essence, [italic type]inhale[roman type] it.".

Instead of drinking an essence:
	take no time;
	say "The gaseous essence is no fluid, and cannot be drunk. You could, however, [italic type]inhale[roman type] it.".


Section - Clothing and body parts 

Clothing is a kind of thing. Clothing is usually wearable.
Does the player mean wearing clothing: it is very likely.

A necklace is a kind of clothing.
A hat is a kind of clothing.
A shirt is a kind of clothing.
A cloak is a kind of clothing.
Shoes are a kind of clothing.
Trousers are a kind of clothing.
A belt is a kind of clothing.
Gauntlets are a kind of clothing.
A mask is a kind of clothing. [Includes masks, goggles, and anything else that covers the face.]
A suit is a kind of clothing. [Suits include hat, shirt, shoes, trousers, gauntlets. Furthermore, you cannot put on a suit if you wear a cursed cloak or a cursed belt.]

Last check wearing a necklace:
	if the player wears a necklace:
		let item be a random necklace worn by the player;
		take no time;
		say "You will first have to take off [the item]." instead. 

Last check wearing a hat:
	if the player wears a hat:
		let item be a random hat worn by the player;
		take no time;
		say "You will first have to take off [the item]." instead;
	[abide by the suit check rule]. 
		
Last check wearing a shirt:
	if the player wears a shirt:
		let item be a random shirt worn by the player;
		take no time;
		say "You will first have to take off [the item]." instead;
	abide by the suit check rule.
		
Last check wearing a cloak:
	if the player wears a cloak:
		let item be a random cloak worn by the player;
		take no time;
		say "You will first have to take off [the item]." instead. 
		
Last check wearing shoes:
	if the player wears shoes:
		let item be a random shoes worn by the player;
		take no time;
		say "You will first have to take off [the item]." instead;
	[abide by the suit check rule]. 
		
Last check wearing a trousers:
	if the player wears a trousers:
		let item be a random trousers worn by the player;
		take no time;
		say "You will first have to take off [the item]." instead;
	abide by the suit check rule. 
		
Last check wearing a belt:
	if the player wears a belt:
		let item be a random belt worn by the player;
		take no time;
		say "You will first have to take off [the item]." instead. 
		
Last check wearing gauntlets:
	if the player wears gauntlets:
		let item be a random gauntlets worn by the player;
		take no time;
		say "You will first have to take off [the item]." instead;
	[abide by the suit check rule]. 
				
Last check wearing a mask:
	if the player wears a mask:
		let item be a random mask worn by the player;
		take no time;
		say "You will first have to take off [the item]." instead. 

Last check wearing a suit:
[	if the player wears a hat:
		let item be a random hat worn by the player;
		take no time;
		say "You will first have to take off [the item]." instead; ]
	if the player wears a shirt:
		let item be a random shirt worn by the player;
		take no time;
		say "You will first have to take off [the item]." instead;
	if the player wears a cursed cloak:
		let item be a random cloak worn by the player;
		take no time;
		say "You will first have to uncurse [the item]." instead; 
[	if the player wears shoes:
		let item be a random shoes worn by the player;
		take no time;
		say "You will first have to take off [the item]." instead; ]
	if the player wears a trousers:
		let item be a random trousers worn by the player;
		take no time;
		say "You will first have to take off [the item]." instead; 
	if the player wears a cursed belt:
		let item be a random belt worn by the player;
		take no time;
		say "You will first have to uncurse [the item]." instead;
[	if the player wears gauntlets:
		let item be a random gauntlets worn by the player;
		take no time;
		say "You will first have to take off [the item]." instead;]
	abide by the suit check rule. 
	
This is the suit check rule:
	if the player wears a suit:
		let item be a random suit worn by the player;
		take no time;
		say "You will first have to take off [the item].";
		rule fails.


Section - Grenades

A grenade is a kind of thing.
A grenade is usually alchemical.
A grenade is usually iron.


Instead of throwing a grenade at something:
	try throwing the noun instead.

Understand the command "throw" as something new.	
Throwing is an action applying to one carried thing. Understand "throw [something]" as throwing.
Does the player mean throwing a grenade: it is likely.

Check throwing:
	if the noun is not a grenade:
		move the noun to the location;
		say "You throw [the noun] away." instead.

Carry out throwing:
	say "Apparently, the programmer has forgotten to implement this type of grenade, because nothing happens!".



Section - Salves

A salve is a kind of thing.
A salve is usually alchemical.

Applying it to is an action applying to one carried thing and one thing. Understand "apply [something] to [something]" as applying it to. Understand "rub [something] on [something]" as applying it to.
Does the player mean applying a salve to something: it is very likely.

Check putting a salve on something:
	try applying the noun to the second noun instead.

Before applying something to a person (this is the putting a salve on someone is risky rule):
	if the faction of the second noun hates the faction of the player:
		if player is not hidden:
			say "The salve at the ready, you attempt to reach [the second noun].";
			now player is risky;
			make the second noun strike a blow against the player;
			now player is not risky;
			if player is killed:
				stop the action;
		now player is not hidden.

Carry out applying something to something:
	say "Nothing particular seems to happen.";
	remove the noun from play.


Section - Sprayables

A sprayable is a kind of thing.
A sprayable is usually alchemical.

Spraying is an action applying to one carried thing. Understand "spray [something]" as spraying.
Does the player mean spraying a sprayable: it is very likely.

Check spraying:
	if noun is not a sprayable:
		take no time;
		say "That cannot be sprayed." instead.



Chapter - Scrolls

A scroll is a kind of thing.
A scroll is usually civilised.
A scroll is usually paper.
The description of a scroll is usually "You'll have to read this scroll to find out what it does.".
Understand "scrolls" as the plural of a scroll.

Reading is an action applying to one carried thing. Understand the command "read" as something new. Understand "read [thing]" as reading.
Does the player mean reading a scroll: it is likely.

Check reading (this is the can only read scrolls rule):
	if the noun is not a scroll:
		take no time;
		say "You cannot read that." instead.

Check reading (this is the cannot read when blind rule):
	if the player is blind:
		take no time;
		say "[The noun] has not been written in braille." instead.

Carry out reading:
	say "Hm. Interesting.".

Section - Unidentified Scrolls

[Mostly by Zed Lopez.]

A thing can be either actual or prototypical. A thing is usually actual.

After cloning a new object from a thing:
	now new object is actual.

A scroll-effect-value is a kind of value. Some scroll-effect-values are defined by the Table of Scroll Effects.

Table of Scroll Effects
scroll-effect-value
scroll-teleportation
scroll-identify
scroll-remove-curse
scroll-ghoulification
scroll-shadows
scroll-summoning
scroll-fireworks
no-effect

Having-knowledge-of relates one person to various scroll-effect-values. The verb to have-knowledge-of (it has-knowledge-of, they have-knowledge-of, it had-knowledge-of, it was-known, it is having-knowledge-of) implies the having-knowledge-of relation.

A scroll is usually prototypical. A scroll has a scroll-effect-value called scroll-effect. A scroll has a truth state called true-name. A scroll is usually improper-named.

Having-scroll-effect relates a scroll (called item) to a scroll-effect-value (called effect) when effect is the scroll-effect of item. The verb to have-scroll-effect (it has-scroll-effect, they have-scroll-effect, it had-scroll-effect, it was scroll-effect-had-by, it is having-scroll-effect) implies the having-scroll-effect relation.

Definition: a scroll (called item) is plain rather than obfuscated if the true-name of item is true.

Scroll-parsable is a kind of value. The scroll-parsables are none-parse, mort-eilysh-parse, naar-od-erae-parse, dolp-zeez-parse, chetnak-parse, cistrob-jirsgev-parse, twan-metier-parse, hermei-le-schim-parse.

A scroll has a scroll-parsable.
Understand the scroll-parsable property as describing a scroll.

Understand "mort" and "eilysh" as mort-eilysh-parse.
Understand "naar" and "od" and "erae" as naar-od-erae-parse.
Understand "dolp" and "zeez" as dolp-zeez-parse.
Understand "chetnak" as chetnak-parse.
Understand "cistrob" and "jirsgev" as cistrob-jirsgev-parse.
Understand "twan" and "metier" as twan-metier-parse.
Understand "hermei" and "le" and "schim" as hermei-le-schim-parse.

Some scrolls are defined by the Table of Magic Scrolls.

Table of Magic Scrolls
scroll							scroll-effect			true-name	plural-name				scroll-parsable	
scroll of teleportation				scroll-teleportation	true			"scrolls of teleportation"	none-parse
scroll of identify					scroll-identify		true			"scrolls of identify"				none-parse
scroll of remove curse				scroll-remove-curse	true			"scrolls of remove curse"	none-parse
scroll of ghoulification				scroll-ghoulification	true			"scrolls of ghoulification"	none-parse
scroll of shadows					scroll-shadows		true			"scrolls of shadows"		none-parse
scroll of summoning				scroll-summoning	true			"scrolls of summoning"			none-parse
scroll of fireworks					scroll-fireworks	true			"scrolls of fireworks"			none-parse
scroll labelled MORT EILYSH		no-effect			false		"scrolls labelled MORT EILYSH"		mort-eilysh-parse
scroll labelled NAAR OD ERAE		no-effect			false		"scrolls labelled NAAR OD ERAE"		naar-od-erae-parse
scroll labelled DOLP ZEEZ			no-effect			false		"scrolls labelled DOLP ZEEZ"	dolp-zeez-parse
scroll labelled CHETNAK			no-effect			false		"scrolls labelled CHETNAK"		chetnak-parse
scroll labelled CISTROB JIRSGEV	no-effect			false		"scrolls labelled CISTROB JIRSGEV"	cistrob-jirsgev-parse
scroll labelled TWAN METIER		no-effect			false		"scrolls labelled TWAN METIER"	twan-metier-parse
scroll labelled HERMEI LE SCHIM		no-effect			false	"scrolls labelled HERMEI LE SCHIM"	hermei-le-schim-parse

First when play begins (this is the set plural names for scrolls rule):
	repeat with item running through scrolls:
		choose a row with scroll of item in Table of Magic Scrolls;
		now printed plural name of item is plural-name entry;
		now item is improper-named.

To scroll-effect-identify (effect - a scroll-effect-value):  
	let realitem be a random prototypical plain scroll which has-scroll-effect effect;
	now player has-knowledge-of effect;
	repeat with item running through every actual on-stage obfuscated scroll which has-scroll-effect effect:
		let itemholder be holder of item;
		let newobject be a new object cloned from realitem;
		remove item from play; [now we must copy all relevant properties]
		if item is flaming:
			now newobject is flaming; [whether it is aflame]
		now heat strength of newobject is heat strength of item; [how hot it is]
		now newobject is in itemholder.

Last check reading a scroll:
	let effect be scroll-effect of the noun;
	remove noun from play;
	if player does not have-knowledge-of effect:
		repeat through Table of Magic Scrolls:
			if scroll-effect entry is effect and true-name entry is true:
				say "It is a [scroll entry]!";
		scroll-effect-identify effect.

Last dungeon interest rule (this is the set up scroll identities rule):
	let l be a list of scroll-effect-values;
	repeat with eachscroll running through every plain prototypical scroll:
		add scroll-effect of eachscroll to l;
	sort l in random order;
	let i be 1;
	repeat with eachscroll running through every obfuscated scroll:
		now scroll-effect of eachscroll is entry i of l;
		if generation info is true, say "* [eachscroll]: [scroll-effect of eachscroll].";
		repeat with item running through every plain scroll:
			if scroll-effect of item is scroll-effect of eachscroll:
				now scroll-parsable of item is scroll-parsable of eachscroll;
		increase i by 1;
	amnesia all scrolls.
		
To amnesia all scrolls:
	repeat with effect running through scroll-effect-values:
		let obfuscateditem be a random prototypical obfuscated scroll which has-scroll-effect effect;
		unless obfuscateditem is nothing:
			repeat with item running through every actual plain on-stage scroll which has-scroll-effect effect:    
				let itemholder be holder of item;
				let newobject be a new object cloned from obfuscateditem;
				remove item from play;
				now newobject is in itemholder.

To copy (item - a thing) to (item2 - a thing):	
	let copy be a new object cloned from item;
	move copy to item2.





Part - Weapons

Chapter - Sword

A sword is a kind of weapon. 
A sword is usually iron.
The passive parry max of a sword is usually 4.

Understand "blade" as a sword.

Chapter - Rapier

A rapier is a kind of weapon. 
A rapier is usually iron.

Understand "blade" as a rapier.

The active parry max of a rapier is usually 3.
The damage die of a rapier is usually 5.

The gilded rapier is a rapier. The player carries the gilded rapier. The gilded rapier is readied.
The gilded rapier is iron.

The description of the gilded rapier is "You took it from the body of the young Count of Poitier, that fateful night in Maurice's whorehouse. He would nevermore plot against you.".


Chapter - Dagger

A dagger is a kind of weapon. 
A dagger is usually iron.

The damage die of a dagger is usually 3.
The weapon attack bonus of a dagger is usually -1.
The dodgability of a dagger is usually 3.
The passive parry max of a dagger is usually 1.
The active parry max of a dagger is usually 1.

An attack modifiers rule (this is the dagger extra tension attack bonus rule):
	if the global attacker weapon is a dagger:
		let n be 0;
		now n is the tension divided by 2;
		if n is not 0:
			if the numbers boolean is true, say " + ", n, " (dagger benefits from tension)[run paragraph on]";
			increase the to-hit modifier by n.
		
A damage modifiers rule (this is the dagger extra tension damage bonus rule):
	if the global attacker weapon is a dagger:
		let n be 0;
		now n is the tension divided by 4;
		if n is not 0:
			if the numbers boolean is true, say " + ", n, " (dagger benefits from tension)[run paragraph on]";
			increase the damage modifier by n.

The special weapon info of a dagger is usually "; benefits from tension[run paragraph on]".


Chapter - Axe

An axe is a kind of weapon. 
An axe is usually iron.

The damage die of an axe is usually 4.
The weapon attack bonus of an axe is usually -1.
The weapon damage bonus of an axe is usually 2.
The dodgability of an axe is usually 3.
The passive parry max of an axe is usually 1.


Chapter - Scythe

A scythe is a kind of weapon. 
A scythe is usually iron.

The damage die of a scythe is usually 10.
The weapon attack bonus of a scythe is usually -2.
The dodgability of a scythe is usually 3.
The passive parry max of a scythe is usually 1.
The active parry max of a scythe is usually 1.




Chapter - Staves 

A staff of pain is a kind of weapon. The plural of staff of pain is staves of pain.
A staff of pain is usually wood. A staff of pain is ranged.

The damage die of a staff of pain is usually 4.
The weapon attack bonus of a staff of pain is usually 1.
The dodgability of a staff of pain is usually 0.
The active parry max of a staff of pain is usually 1.
The passive parry max of a staff of pain is usually 0.







Chapter - Item properties

Section - Incorruptible

[Incorruptible objects are immune from all effects adversely affecting them.]

A thing can be corruptible or incorruptible. A thing is usually corruptible.


Section - Hidden identity

[Some objects appear to be A, but are actually B. In order to do handle this smoothly, including references to it, we just use object A, and replace it with object B as soon as it is used.]

The non-thing is a thing. [This is a dummy object.]

A thing has a thing called the hidden identity. The hidden identity of a thing is usually the non-thing.

Report wearing:
	unless the hidden identity of the noun is the non-thing:
		now the hidden identity of the noun is curse-identified;
		now the player is wearing the hidden identity of the noun;
		set pronouns from the hidden identity of the noun;
		remove the noun from play;
		say "As soon as you put on [the noun], your flesh crawls. You realise that [the noun] [is-are] actually the [hidden identity of the noun]." instead.


Section - Cursed

A thing can be cursed or not cursed. A thing is usually not cursed.
A thing can be curse-identified or not curse-identified. A thing is usually not curse-identified.

Understand the cursed property as describing a thing.

Section - Cursed clothing

Check taking off something:
	if the noun is cursed:
		say "A curse makes the item unmovable." instead.

After wearing a cursed not curse-identified thing:
	 say "As soon as you put on [the noun], a chill goes through your body. You realise that [the noun] [is-are] cursed and cannot be removed with normal means.";
	now the noun is curse-identified.
		
Before printing the name of a cursed curse-identified thing:
	say "cursed ".

A treasure placement rule:
	repeat with item running through corruptible clothing:
		if a random chance of 1 in 5 succeeds and a random chance of difficulty in 5 succeeds:
			now item is cursed;
			if generation info is true, say "* Cursed [item].";			
		if item is cursed and a random chance of 1 in 5 succeeds:
			now item is curse-identified.
			
Section - Cursed weapons

After readying something cursed:
	say "As soon as you ready [the noun], a chill goes through your body. You realise that [the noun] [is-are] cursed and that you cannot let go.";
	now the noun is curse-identified.

Check readying (this is the cannot ready when holding a cursed weapon rule):
	if the player has a readied cursed weapon:
		let item be a random readied cursed weapon had by the player;
		say "You cannot ready a new weapon until you have gotten rid of [the item]." instead.

Check dropping (this is the cannot drop a cursed readied weapon rule):
	if the noun is a readied cursed weapon had by the player:
		say "You cannot let go of [the noun]." instead.

Check putting it on (this is the cannot put on a cursed readied weapon rule):
	if the noun is a readied cursed weapon had by the player:
		say "You cannot let go of [the noun]." instead.
		
Check inserting it into (this is the cannot insert a cursed readied weapon rule):
	if the noun is a readied cursed weapon had by the player:
		say "You cannot let go of [the noun]." instead.

A treasure placement rule:
	repeat with item running through corruptible weapons:
		unless item is the gilded rapier or item is a natural weapon:
			if a random chance of 1 in 10 succeeds and a random chance of difficulty in 5 succeeds:
				now item is cursed;
				if generation info is true, say "* Cursed [item].";
			if item is cursed and a random chance of 1 in 4 succeeds:
				now item is curse-identified.


Chapter - Minor treasures

Section - Essence of Caution

The essence of caution is a minor essence. The indefinite article is "the".
The essence of caution is magical.
The essence of caution is iron.
The difficulty level of an essence is usually 1.

A person can be cautious or not cautious. A person is usually not cautious.

The description of the essence of caution is "This small metal bottle contains the magical essence of caution, distilled from the brain of [one of]the only councilor of Hargo the Furious of Yahvinna who lived to die of old age[or]the famous Algirian general al-Hawabi, who fought only two battles in a forty year campaign -- and won both[or]an unknown rogue, whose exploits would be legendary if only they were known[sticky random]. When inhaled, it confers this mindset to the user. [italic type](+1 perception, +2 defence bonus when retreating, sometimes lose initiative.)[roman type]".

Carry out inhaling the essence of caution:
	say " The decision to do this suddenly seems exceedingly rash.";[[paragraph break](You have gained 1 perception, and a +2 defence bonus when retreating. You may sometimes lose initiative in combat.)[paragraph break]]
	increase perception of the player by 1;
	now the player is cautious.
	
Initiative rule (this is the sometimes loses initiative when cautious rule):
	repeat with X running through all alive persons enclosed by the location:
		if X is cautious:
			if a random chance of 1 in 20 succeeds:
[				if X is the player:
					say "Acting seems a bit rash to you, so you decide to wait instead.";]
				decrease the initiative of X by 4.
		
An attack modifiers rule (this is the caution grants better retreat rule):
	if the global defender is the player and the player is retreater:
		if the player is cautious:
			if the numbers boolean is true, say " - 2 (essence of caution)[run paragraph on]";
			decrease the to-hit modifier by 2.


Section - Essence of Rage

The essence of rage is a minor essence. The indefinite article is "the".
The essence of rage is magical.
The essence of rage is iron.

A person can be enraged or not enraged. A person is usually not enraged.

The description of the essence of rage is "This small metal bottle contains the magical essence of rage, distilled from the brain of [one of]a berserk warrior from the far north[or]Charles IV of Averoigne, who, at the moment of his greatest victory, was poisoned by the brother he had always cherished[sticky random]. When inhaled, it confers this mindset to the user. [italic type](+1 willpower, +1 attack, unable to retreat.)[roman type]".

Carry out inhaling the essence of rage:
	say " You will show them all that you are not to be toyed with!";
	increase willpower of the player by 1;
	increase melee of the player by 1;
	now the player is enraged.

Last check retreating (this is the do not retreat when enraged rule):
	if hate is present and the player is enraged:
		let Y be the player;
		repeat with X running through persons in the location:
			if the faction of X hates the faction of the player:
				now Y is X;
		take no time;
		say "And allow [the Y] to live? Never!" instead.

Last check going (this is the do not go in combat when enraged rule):
	if hate is present and the player is enraged:
		let Y be the player;
		repeat with X running through persons in the location:
			if the faction of X hates the faction of the player:
				now Y is X;
		take no time;
		say "And allow [the Y] to live? Never!" instead.



Section - Essence of Patience

The essence of patience is a major essence. The indefinite article is "the".
The essence of patience is magical.
The essence of patience is iron.

A person can be patient or not patient. A person is usually not patient.

The description of the essence of patience is "This small metal bottle contains the magical essence of patience, distilled from the brain of [one of]a High Priest of Yahvinna who endured fifty-three years of torture just to hear the news of his enemy's death[or]the author of 'A Careful Calculation of the first Twenty Thousand Decimals of the Squared Circle'[sticky random]. When inhaled, it confers this mindset to the user. [italic type](Whenever you wait, the tension is halved.)[roman type]".

Carry out inhaling the essence of patience:
	say " You relish the smell. There is no need to hurry.";
	now the player is patient.

Carry out waiting:
	if player is patient:
		now tension is tension divided by 2.

First report waiting:
	if player is patient:
		say "You wait patiently. You feel no tension." instead.




Section - Tormenting necklace

The tormenting necklace is a minor necklace.
The tormenting necklace is deathly.

The description of the tormenting necklace is "This monstrous necklace is made of shards of glass, fossilised teeth, broken points of daggers and thorns. It is imbued with a magic that deals paralysing pain to anyone who is wounded in combat. [italic type](This necklace lowers the initiative of anyone who gets hit -- including you -- thus increasing the probability that a successful attacker can immediately act again.)[roman type]".

[TODO -- we want some monsters to be immune to this effect.]

Aftereffects rule (this is the tormenting necklace rule):
	if the player wears the tormenting necklace:
		if final damage is greater than 0:
			decrease initiative of the global defender by 2.



Section - Goggles of acuity

The goggles of acuity are a minor mask. They are plural-named. The indefinite article is "the". 
The goggles of acuity are civilised.
The goggles of acuity are leather.

A treasure placement rule (this is the acuity can be blindness rule):
	if a random chance of 1 in 6 succeeds:
		now the hidden identity of the goggles of acuity is the goggles of blindness.

A perception test rule (this is the perception bonus of the goggles of acuity rule): [BUG with chain golem]
	if the test subject wears the goggles of acuity:
		increase test score by 2;
		say " + 2 (goggles of acuity)[run paragraph on]".

The description of the goggles of acuity is "These goggles have been magically enchanted to grant sharper eyesight to the wearer. They were made for the marquis of Savon, who wasted his eyes poring over ancient tomes in his ill-lit library. [italic type](They grant a +2 bonus on perception checks.)[roman type]".

Section - Goggles of blindness

The goggles of blindness are a cursed curse-identified mask. They are plural-named. The indefinite article is "the". 
The goggles of blindness are leather.

A blindness rule (this is the goggles of blindness rule):
	if the test subject wears the goggles of blindness:
		rule succeeds.

The description of goggles of blindness is "These goggles prevent the wearer from seeing anything at all. A free-for-all fight between condemned criminals forced to wear such goggles is one of the most beloved shows during the Feast of Flesh; you have to smile as you recall the spectacle.".

Section - Crown of the empire

The crown of the empire is a minor hat. The indefinite article is "the". 
The crown of the empire is civilised.
The crown of the empire is iron.

A treasure placement rule (this is the crown of empire can be crown of Hargo rule):
	if a random chance of 1 in 6 succeeds:
		now the hidden identity of the crown of the empire is the crown of Hargo.

A willpower test rule (this is the willpower bonus of the crown of the empire rule):
	if the test subject wears the crown of the empire:
		increase test score by 2;
		say " + 2 (crown of the empire)[run paragraph on]".

The description of the crown of the empire is "This harsh and heavy crown was once worn by one of the emperors of Yahvinna, a line of rulers known for their unbending willpower. [italic type](It grants a +2 bonus on willpower checks.)[roman type]".

Section - Crown of Hargo

The crown of Hargo is a cursed curse-identified hat. The indefinite article is "the". 
The crown of Hargo is iron.

An attack modifiers rule (this is the crown of Hargo rule):
	if the global defender wears the crown of Hargo:
		if the numbers boolean is true, say " + 1 (defender is overconfident)[run paragraph on]";
		increase the to-hit modifier by 1.

Chance to win rule (this is the CTW crown of Hargo bonus rule):
	if the global defender wears the crown of Hargo:
		increase the chance-to-win by 1.

A willpower test rule (this is the willpower bonus of crown of Hargo rule):
	if the test subject wears the crown of Hargo:
		increase test score by 4;
		say " + 4 (crown of Hargo)[run paragraph on]".

The description of Crown of Hargo is "Of all the emperors of Yahvinna, Hargo was the most arrogant and the most obstinate. This was both the foundation of his military successes and the cause of his eventual downfall. [italic type](The crown grants a +4 bonus on willpower checks, but a -1 penalty to defence.)[roman type]".




Section - Flash grenades

A flash grenade is a kind of grenade. The description of a flash grenade is "When thrown, this magical grenade emits a pulse of searing light so strong that it will blind anyone in its vicinity, even if they close their eyes. The device is universally judged to be Metastasio's most useless invention.".
A flash grenade is iron.

Instead of throwing a flash grenade:
	let lijst be a list of person;
	repeat with guy running through alive persons in the location:
		unless guy is blind:
			add guy to lijst;
			now guy is blinded;
	say "You throw the flash grenade, and a blinding light [unless lijst is empty]burns away the retinae of anyone unlucky enough to look at it, that is, [lijst with definite articles][otherwise]flashes through the room[end if].";
	remove noun from play.


The small-flash-grenade-pack is a minor treasure pack. Two flash grenades are in the small-flash-grenade-pack.
The small-flash-grenade-pack is elemental.

The large-flash-grenade-pack is a major treasure pack. Three flash grenades are in the large-flash-grenade-pack.
The large-flash-grenade-pack is elemental.



Section - Rust grenade

A rust grenade is a kind of grenade. The description of a rust grenade is "When thrown, this grenade will release a thick cloud of rust spores -- a nasty fungus that rusts away iron. Its use is forbidden in all civilised and most uncivilised countries.".
A rust grenade is iron.

Instead of throwing a rust grenade:
	say "You throw the rust grenade, and it immediately releases a cloud of rust spores!";
	remove noun from play;
	now the location is rust-spored.

The small-rust-grenade-pack is a minor treasure pack. One rust grenade is in the small-rust-grenade-pack.
The small-rust-grenade-pack is barren.




Section - Smoke grenade

A smoke grenade is a kind of grenade. The description of a smoke grenade is "When thrown, this grenade will release thick clouds of smoke. You once used such devices to help the prince escape from a confrontation with the henchmen of the vengeful countess of Poitier; that was long before your relationship soured.".
A smoke grenade is iron.

Instead of throwing a smoke grenade:
	say "You throw the smoke grenade, and it immediately explodes into a large cloud of smoke.";
	remove noun from play;
	if the smoke timer of the location is less than 8:
		now the smoke timer of the location is 8.

The small-smoke-grenade-pack is a minor treasure pack. One smoke grenade is in the small-smoke-grenade-pack.
The small-smoke-grenade-pack is alchemical.

The large-smoke-grenade-pack is a major treasure pack. Three smoke grenades are in the large-smoke-grenade-pack.
The large-smoke-grenade-pack is alchemical.




Section - Fragmentation grenade

A fragmentation grenade is a kind of grenade. The description of a fragmentation grenade is "When thrown, the [if the fragmentation grenade is silver]silver [end if]fragmentation grenade will explode into many sharp fragments. These are guaranteed to deal damage to everyone in the location[if the fragmentation grenade is silver], but especially to undead[end if]. You cannot handle these items without a feeling of national pride; for it was this invention of Metastasio's that allowed the outnumbered forces of Louis VIII to defeat the Algirian hordes.".
A fragmentation grenade is iron.
Understand "frag" as a fragmentation grenade.

Instead of throwing a fragmentation grenade:
	remove the noun from play;
	say "The grenade explodes, dealing [run paragraph on]";
	let n be the number of alive persons in the location;
	let original n be n;
	repeat with guy running through all alive persons in the location:
		let m be a random number between 2 and 5;
		if the noun is silver and the guy is undead:
			increase m by 3;
		calculate the pdr for guy;
		decrease m by pdr;
		if m is less than 0, now m is 0;			
		decrease health of guy by m;
		say "[no dead property][if n is 1 and original n is not 1]and [end if][m] damage to [the guy][if guy is killed] (which is [bold type]lethal[roman type])[end if][roman type][if concentration of the guy is greater than 0 and guy is alive] (which breaks [possessive of the guy] concentration)[end if][if n is not 1]; [otherwise].[line break][end if][dead property][run paragraph on]";
		now concentration of the guy is 0;
		decrease n by 1;
		if n is 0:
			say ""; [For an extra newline. Don't ask.]
	if health of the player is less than 1:
		end the game saying "You have blown yourself to pieces.".



The small-fragmentation-grenade-pack is a minor treasure pack. One fragmentation grenade is in the small-fragmentation-grenade-pack.
The small-fragmentation-grenade-pack is alchemical.

The large-fragmentation-grenade-pack is a major treasure pack. Two fragmentation grenades are in the large-fragmentation-grenade-pack.
The large-fragmentation-grenade-pack is alchemical.


Section - Blessed Grenade

The Blessed Grenade is a major grenade. The indefinite article of the Blessed Grenade is "the". The description of Blessed Grenade is "This grenade is rumoured to be extremely effective against undead.".

Instead of throwing the Blessed Grenade:
	remove the noun from play;
	if the number of undead persons in the location is less than 1:
		say "As the grenade explodes you hear the singing of angels. But nothing further appears to happen.";
	otherwise:
		let K be a list of persons;
		repeat with guy running through alive undead persons in the location:
			now health of guy is -1;
			add guy to K;
		say "As the grenade explodes you hear the singing of angels, several of whom swoop down from the heavens with huge swords and eviscerate [no dead property][K with definite articles][dead property].";
		if the player is killed:
			end the story saying "The undead should not seek blessings.".


Section - Metastasio's hat

Metastasio's hat is a minor hat. The description of Metastasio's hat is "Metastasio envisioned whole armies that would lob grenades at the enemy and would then run away as fast as they could. This hat was meant as a prototype piece of equipment to help with the latter. But the generals of Averoigne did not share Metastasio's ideas, and Louis VIII expressly forbade further production of these hats, a decision the chroniclers have all lauded.". Metastasio's hat is proper-named.
Metastasio's hat is alchemical.
Metastasio's hat is cloth.

An attack modifiers rule (this is the Metastasio's hat grants better retreat rule):
	if the global defender is the player and the player is retreater:
		if the player wears Metastasio's hat:
			say " - 2 (your cowardice)[run paragraph on]";
			decrease the to-hit modifier by 1.

An attack modifiers rule (this is the Metastasio's hat grants worse attack rule):
	if the global attacker is the player:
		if the player wears Metastasio's hat:
			say " - 2 (your cowardice)[run paragraph on]";
			decrease the to-hit modifier by 2.


Section - War mask

The war mask is a minor mask. The description of the war mask is "This warlike metal mask is painted with the holy symbols of Aite, and is a sacred object of her religion.".
The war mask is religious.
The war mask is iron.

A beloved of Aite rule (this is the war mask Aite rule):
	if the test subject wears the war mask:
		rule succeeds.

Section - Gorgeous dagger

The gorgeous dagger is a minor dagger.
The gorgeous dagger is civilised.
The gorgeous dagger is iron.

The description of the gorgeous dagger is "Adorned with gold and a large emerald at the end of the hilt, this dagger is not only beautiful, but also perfect for precise attacks in tense situations. The decadence of its design proves it to be of Yahvinnean origin.".


Section - Fearsome axe

The fearsome axe is a minor axe.
The fearsome axe is deathly.
The fearsome axe is iron.

The damage die of the fearsome axe is 5.
The active parry max of the fearsome axe is 1.

The description of the fearsome axe is "While not exactly a nimble weapon, this fearsome axe is certainly able to deal out some punishment.".


Section - Dimensional anchor

A dimensional anchor is a minor thing. The description of the dimensional anchor is "The tiny anchor made of marble may seem nothing but a sailor's souvenir, but appearances deceive. It has been imbued with a powerful spell that makes it impossible to teleport away from the room it is in. An ornate 'N' at the bottom designates it as the work of the mysterious sorcerer Ningauble.".
The dimensional anchor is magical.
The dimensional anchor is stone.

A teleport impossible rule (this is the dimensional anchor rule):
	if the location of the test subject encloses the dimensional anchor:
		rule succeeds.


Section - Unguentum argenti

An unguentum argenti is a kind of salve. The plural of unguentum argenti is unguenta argenti. The description of unguentum argenti is "An expensive alchemical salve that can be rubbed on iron objects to turn them into silver.". Understand "salve" as unguentum argenti.

Instead of applying unguentum argenti to an iron weapon:
	say "You carefully apply the salve to [the second noun], turning it into a silver weapon.";
	now the second noun is silver;
	remove noun from play.

Instead of applying unguentum argenti to an alive iron person:
	say "You apply the salve wherever you can, significantly weakening [the second noun].";
	now the second noun is silver;
	remove noun from play;
	now permanent health of the second noun is permanent health of the second noun divided by 2;
	now health of the second noun is health of the second noun divided by 2;
	if health of the second noun is less than 1:
		now health of the second noun is 1.

Instead of applying unguentum argenti to an iron thing:
	say "You carefully apply the salve to [the second noun], turning it into silver.";
	now second noun is silver;
	remove noun from play.
		
The small-unguentum-argenti-pack is a minor treasure pack. One unguentum argenti is in the small-unguentum-argenti-pack.
The small-unguentum-argenti-pack is alchemical.

The large-unguentum-argenti-pack is a major treasure pack. Two unguenta argenti are in the large-unguentum-argenti-pack.
The large-unguentum-argenti-pack is alchemical.


Section - Scroll of teleportation		
		
[A scroll of teleportation is a kind of scroll.] The description of a scroll of teleportation is "Reading this scroll will instantaneously transport the reader to another location.". The plural of scroll of teleportation is scrolls of teleportation.
A scroll of teleportation is paper.
[The printed name of a scroll of teleportation is "scroll of teleportation". [Circumventing bug 459: http://inform7.com/mantis/view.php?id=459.]]

Carry out reading a scroll:
	if scroll-effect of the noun is scroll-teleportation:
		remove noun from play;
		unless teleportation is impossible for the player:
			teleport the player;
		otherwise:
			say "The scroll disappears, but something has stopped you from teleporting.";
		rule succeeds.

To teleport the player:
	let destination be a random placed teleportable room;
	while destination is the location of the player:
		let destination be a random placed teleportable room;
	say "A sickening feeling, and then you find yourself in --[paragraph break]";
	now retreat location is destination;
	consider the sudden combat reset rules;
	move player to destination;
	now the take no time boolean is false.


The small-scroll-of-teleportation-pack is a minor treasure pack.
The small-scroll-of-teleportation-pack is civilised.

A treasure placement rule:
	copy scroll of teleportation to small-scroll-of-teleportation-pack.
	
The large-scroll-of-teleportation-pack is a major treasure pack. [Two scrolls of teleportation are in the large-scroll-of-teleportation-pack.] [Stock the large-scroll-of-teleportation-pack with 2 clones of scroll of teleportation.]
The large-scroll-of-teleportation-pack is civilised.

A treasure placement rule:
	copy scroll of teleportation to large-scroll-of-teleportation-pack;
	copy scroll of teleportation to large-scroll-of-teleportation-pack.


Section - Scroll of Ghoulification		

The ghoul boolean is a truth state that varies. The ghoul boolean is false.

[A scroll of ghoulification is a kind of scroll.] The description of a scroll of ghoulification is "Reading this scroll will turn you into an undead ghoul.". The plural of scroll of ghoulification is scrolls of ghoulification.
A scroll of ghoulification is paper.
The printed name of a scroll of ghoulification is "scroll of ghoulification". [Circumventing bug 459: http://inform7.com/mantis/view.php?id=459.]

Carry out reading a scroll:
	if scroll-effect of the noun is scroll-ghoulification:
		remove noun from play;
		unless the player is undead:
			say "As you read the scroll, your flesh starts to rot and most of your vital functions cease. You have been turned into a ghoul!";
			now the faction of the player is undead;
			decrease melee of the player by 1;
			now the ghoul boolean is true;
		otherwise:
			say "As you are undead already, the scroll has no effect on you.";
		rule succeeds.

A damage modifiers rule (this is the ghoul gives damage resistance rule):
	if the global defender is the player and the ghoul boolean is true:
		if the numbers boolean is true, say " - 1 (you are a ghoul)[run paragraph on]";
		decrease the damage modifier by 1.

The small-scroll-of-ghoulification-pack is a minor treasure pack. [One scroll of ghoulification is in the small-scroll-of-ghoulification-pack.]
The small-scroll-of-ghoulification-pack is civilised.
The difficulty level of the small-scroll-of-ghoulification-pack is 1.

A treasure placement rule:
	copy scroll of ghoulification to small-scroll-of-ghoulification-pack.


Status rule (this is the ghoul status rule):
	if the ghoul boolean is true:
		say "You are a [bold type]ghoul[roman type]: -1 attack; +1 damage resistance.[line break][run paragraph on]".

To do the unghoul:
	now the faction of the player is friendly;
	increase melee of the player by 1;
	now ghoul boolean is false.


Section - Scroll of Identify		

[A scroll of identify is a kind of scroll.] The description of a scroll of identify is "Reading this scroll will grant you knowledge about all other scrolls.". The plural of scroll of identify is scrolls of identify.
A scroll of identify is paper.
The printed name of a scroll of identify is "scroll of identify". [Circumventing bug 459: http://inform7.com/mantis/view.php?id=459.]

Carry out reading a scroll:
	if scroll-effect of the noun is scroll-identify:
		remove noun from play;
		say "The nature of scrolls suddenly becomes clear to you.";
		repeat with item running through prototypical obfuscated scrolls:
			let effect be scroll-effect of item;
			scroll-effect-identify effect;
		rule succeeds.

The small-scroll-of-identify-pack is a minor treasure pack. [One scroll of identify is in the small-scroll-of-identify-pack.]
The small-scroll-of-identify-pack is civilised.
A treasure placement rule:
	copy scroll of identify to small-scroll-of-identify-pack.


Section -  Scroll of Remove Curse

[A scroll of remove curse is a kind of scroll.] The description of a scroll of remove curse is "Reading this scroll will uncurse any items you are carrying.". The plural of scroll of remove curse is scrolls of remove curse.
A scroll of remove curse is paper.
The printed name of a scroll of remove curse is "scroll of remove curse". [Circumventing bug 459: http://inform7.com/mantis/view.php?id=459.]

Carry out reading a scroll:
	if scroll-effect of the noun is scroll-remove-curse:
		remove noun from play;
		if the player has at least one cursed corruptible thing:
			let K be a list of things;
			repeat with item running through cursed corruptible things had by the player:
				now item is not cursed;
				add item to K;
			say "The scroll uncurses [K with definite articles].";
		otherwise:
			say "The scroll does nothing, since you had no cursed items.";
		rule succeeds.

The small-scroll-of-remove-curse-pack is a minor treasure pack.
The small-scroll-of-remove-curse-pack is civilised.
A treasure placement rule:
	copy scroll of remove curse to small-scroll-of-remove-curse-pack.

The large-scroll-of-remove-curse-pack is a major treasure pack.
The large-scroll-of-remove-curse-pack is civilised.
A treasure placement rule:
	copy scroll of remove curse to large-scroll-of-remove-curse-pack;
	copy scroll of remove curse to large-scroll-of-remove-curse-pack..

Section - Scroll of Shadows
		
[A scroll of shadows is a kind of scroll.] The description of a scroll of shadows is "Reading this scroll will make you hidden, but only when there are no enemies nearby.". The plural of scroll of shadows is scrolls of shadows.
A scroll of shadows is paper.
The printed name of a scroll of shadows is "scroll of shadows". [Circumventing bug 459: http://inform7.com/mantis/view.php?id=459.]

Carry out reading a scroll:
	if scroll-effect of the noun is scroll-shadows:
		remove noun from play;
		if the player is hidden:
			say "The scroll disappears and you remain hidden.";
		otherwise if not hate is present:
			now the player is hidden;
			say "You blend into the shadows.";
		otherwise:
			say "The scroll disappears, but you remain visible.";
		rule succeeds.

The small-scroll-of-shadows-pack is a minor treasure pack.
The small-scroll-of-shadows-pack is civilised.	
A treasure placement rule:
	copy scroll of shadows to small-scroll-of-shadows-pack.

The large-scroll-of-shadows-pack is a major treasure pack.
The large-scroll-of-shadows-pack is civilised.
A treasure placement rule:
	copy scroll of shadows to large-scroll-of-shadows-pack;
	copy scroll of shadows to large-scroll-of-shadows-pack.

Section - Scroll of Summoning

[A scroll of summoning is a kind of scroll.] The description of a scroll of summoning is "Reading this scroll will summon an undead monster. Be careful, for it does not make the creature friendly.". The plural of scroll of summoning is scrolls of summoning.
A scroll of summoning is paper.
The printed name of a scroll of summoning is "scroll of summoning". [Circumventing bug 459: http://inform7.com/mantis/view.php?id=459.]

Carry out reading a scroll:
	if scroll-effect of the noun is scroll-summoning:
		remove noun from play;
		if at least one alive undead person is off-stage:
			let guy be a random alive off-stage undead person;
			move guy to location of the player;
			say "You speak the awful spell, and [a guy] appears before you!";
			now guy is follower;
			unless the follower percentile chance of guy is greater than 60:
				now follower percentile chance of guy is 60;
		otherwise:
			say "You speak the awful spell, but nothing happens. The planes must not be well-aligned.";
		rule succeeds.

The small-scroll-of-summoning-pack is a minor treasure pack.
The small-scroll-of-summoning-pack is magical.	
The difficulty level of the small-scroll-of-summoning-pack is 1.

A treasure placement rule:
	copy scroll of summoning to small-scroll-of-summoning-pack.

Section - Scroll of fireworks

The description of a scroll of fireworks is "Who knows what this weird scroll will do?". The plural of scroll of fireworks is scrolls of fireworks.
A scroll of fireworks is paper.
The printed name of a scroll of fireworks is "scroll of fireworks". [Circumventing bug 459: http://inform7.com/mantis/view.php?id=459.]

Carry out reading a scroll:
	if scroll-effect of the noun is scroll-fireworks:
		remove noun from play;
		say "Gratuitous purple fireworks fill the room, spelling the words [bold type]YOU HAVE LOST THE GAME[roman type].";
		rule succeeds.

The small-scroll-of-fireworks-pack is a minor treasure pack.
The small-scroll-of-fireworks-pack is magical.	

A treasure placement rule:
	if a random chance of 1 in 50 succeeds: [This scroll appears only very rarely.]
		copy scroll of fireworks to small-scroll-of-fireworks-pack.


Section - Asbestos vest

The asbestos vest is a minor shirt. The description of asbestos vest is "While it doesn't provide much protection against weapons, this vest could be useful for its fire resistance. It bears the signs of the Montenoir alchemist guild.".
Asbestos vest is alchemical.
Asbestos vest is other-material.

Heat resistance rule (this is the asbestos vest heat resistance rule):
	if test subject wears asbestos vest:
		increase temp-heat by 4.


Section - Fungicide

The fungicide contraption is a minor sprayable. The description of the fungicide contraption is "This weird contraption contains a powerful fungus killing substance. Spraying it will immediately clear a room of all spores.".

Carry out spraying fungicide contraption:
	if location is rust-spored:
		say "You spray the fungicide all around. The rust spores blacken and wither.";
		now location is not rust-spored;
	otherwise:
		say "You spray the fungicide all around.".




Section - Executioner's axe

The executioner's axe is a major axe.
The executioner's axe is deathly.
The executioner's axe is iron.

The description of the executioner's axe is "This is the blade that chopped off the head of Philip the Traitor after he had been found guilty of murdering his brother, Charles IV. Ever since, pilgrims have flocked to Montenoir's temple of Nomos to see and revere it. How it has ended up in this dungeon is anyone's guess.".

The damage die of the executioner's axe is 7.
The weapon damage bonus of the executioner's axe is 4.
The active parry max of the executioner's axe is 0.
The dodgability of the executioner's axe is 3.
The weapon attack bonus of the executioner's axe is -3.

A damage modifiers rule (this is the executioner's axe extra tension damage bonus rule):
	if the global attacker weapon is the executioner's axe:
		let n be 0;
		now n is the tension divided by 3;
		if n is not 0:
			if the numbers boolean is true, say " + ", n, " (executioner's axe benefits from tension)[run paragraph on]";
			increase the damage modifier by n.

An attack modifiers rule (this is the executioner's axe is better in temple of Nomos rule):
	if the global attacker weapon is the executioner's axe and the location is the Temple of Nomos:
		if the numbers boolean is true, say " + 3 (Nomos likes the executioner's axe)[run paragraph on]";
		increase the to-hit modifier by 3.

The special weapon info of the executioner's axe is "; better tension damage bonus[run paragraph on]".


Section - Magical spade

The magical spade is a major thing. The magical spade is a digging tool. The description of the magical spade is "Used by wizards to construct their dungeons, a magical spade can be used to dig tunnels in whatever direction you wish. Just dig north, for instance.".
The magical spade is magical.
The magical spade is iron.			


Section - Boots of the war dance

The boots of the war dance are major shoes. The boots of the war dance are plural-named. The indefinite article of the boots of the war dance is "the". The description of boots of the war dance is "These graceful boots, supposedly made by the master of Algir, will grant you impeccable footwork in combat. This will undoubtedly grant you extra turns now and then.".
Boots of the war dance are civilised.

Initiative rule (this is the boots of the war dance give initiative rule):
	if the player wears the boots of the war dance:
		if a random chance of 1 in 13 succeeds:
			increase the initiative of the player by 5.

A treasure placement rule (this is the war dance can be wandering rule):
	if a random chance of 1 in 8 succeeds:
		now the hidden identity of the boots of the war dance is boots of wandering.

Section - Boots of wandering

The boots of wandering are cursed curse-identified shoes. The boots of wandering are plural-named. The indefinite article of boots of wandering is "the". The description of boots of wandering is "These graceful boots, supposedly made by the master of Algir, will grant you impeccable footwork in combat. This will undoubtedly grant you extra turns now and then. Unfortunately, when a prince of Algir wore these boots in the War of the Woods, they were cursed by a dying druid. It is now exceedingly unsafe to wear them.".

Initiative rule (this is the boots of the boots of wandering give initiative rule):
	if the player wears the boots of wandering:
		if a random chance of 1 in 13 succeeds:
			increase the initiative of the player by 5.

Before doing anything (this is the boots of wandering weirdness rule):
	if the player wears the boots of wandering and a random chance of 1 in 40 succeeds:
		if at least one room is adjacent to the location of the player:
			let place2 be the location of the player; [needed because of a bug in inform]
			let place be a random room which is adjacent to place2;
			let way be the direction from the location of the player to place;
			say "Before you can do anything, the [bold type]boots of wandering[roman type] attempt to run [way]!";
			now forced-action is true;
			try going way instead.


[Dance-said is a truth state that varies. Dance-said is false.

Every turn when the player is wearing Ottonian dancing boots:
	if dance-said is false:
		now dance-said is true;
		say "The boots force you to [bold type]start dancing[roman type]!".

Every turn when the player is not wearing Ottonian dancing boots:
	if dance-said is true:
		now dance-said is false;
		say "You can finally [bold type]stop dancing[roman type].".

Initiative rule (this is the Ottonian dancing boots take away initiative rule):
	if the player wears Ottonian dancing boots:
		if a random chance of 1 in 2 succeeds:
			decrease the initiative of the player by 1;
		otherwise if a random chance of 1 in 8 succeeds:
			decrease the initiative of the player by 2.

Status rule (this is the dancing status rule):
	if player is wearing Ottonian dancing boots:
		say "You are [bold type]dancing[roman type], which lowers your initiative in combat.[line break][run paragraph on]".

Instead of cutting the Ottonian dancing boots:
	say "They seem to be too tough.".]



Section - Suit of plate mail

The suit of plate mail is a major suit.
Suit of plate mail is alchemical.
Suit of plate mail is iron.

Constriction prevention of suit of plate mail is 3.

The description of the suit of plate mail is "Functional rather than beautiful, this suit has been made for a true warrior. It will protect you from harm, although it also slows you down.".			
			
A damage modifiers rule (this is the plate mail damage modifiers rule):
	if the global defender is wearing the suit of plate mail:
		if the global attacker weapon is armour-stoppable:
			say " - 2 (plate mail)[run paragraph on]";
			decrease the damage modifier by 2.

A physical damage reduction rule (this is the plate mail physical damage reduction rule):
	if the test subject is wearing the suit of plate mail:
		increase the pdr by 2.

Initiative rule (this is the suit of plate mail takes away initiative rule):
	if the player wears suit of plate mail:
		if a random chance of 1 in 2 succeeds:
			decrease the initiative of the player by 1.

An attack modifiers rule (this is the plate mail attack modifiers rule):
	if the global defender wears suit of plate mail:
		if the global defender is retreater or the global defender is runner:
			say " + 2 (slowed down by plate mail)[run paragraph on]";
			increase the to-hit modifier by 2;
	if the global attacker wears suit of plate mail:
		say " - 1 (slowed down by plate mail)[run paragraph on]";
		decrease the to-hit modifier by 1.

An attack modifiers rule (this is the plate mail running rule):
	if the global defender is the player and the player carries the suit of plate mail:
		if the player is retreater or the player is runner:
			say " + 2 (you are slowed down by carrying a suit of plate mail)[run paragraph on]";
			increase the to-hit modifier by 2.

A standard AI action select rule (this is the plate mail concentration select rule):
	choose row with an Option of the action of the global attacker concentrating in the Table of AI Combat Options;
	if the global defender is wearing the suit of plate mail:
		increase the Weight entry by 3.




Chapter - Epic Items

Section - Cloak of shadows

The cloak of shadows is an epic cloak.
The cloak of shadows is civilised.
The cloak of shadows is cloth.

The description of the cloak of shadows is "Wearing this powerful cloak allows you to become hidden and sneak through the dungeon undetected. You cannot hide in the presence of enemies, though.".

Every turn when the player wears the cloak of shadows (this is the blend into shadows rule):
	if not hate is present:
		if the player is not hidden:
			now the player is hidden;
			say "You blend into the shadows.".

After taking off the cloak of shadows when the player is hidden:
	now player is not hidden;
	say "You reveal your presence to the world.".


Section - Glass Cannon

[Very good weapon which halves you permanent health.]

The glass cannon is an epic weapon.
The glass cannon is magical.
The material of the glass cannon is glass.

The glass cannon is ranged.

The description of the glass cannon is "At first sight this seems to be nothing but a foot-long tube of glass. However, it is a very powerful weapon, the shots of which can quickly destroy even the most powerful enemy. But be warned: not only does the glass cannon make you an easier target, it is also the case that when you ready the weapon, you [bold type]permanently[roman type] lose half of your health.".

The damage die of the glass cannon is 0.
The weapon attack bonus of the glass cannon is 3.
The weapon damage bonus of the glass cannon is 12.
The dodgability of the glass cannon is 2.
The passive parry max of the glass cannon is 0.
The active parry max of the glass cannon is 3.

An attack modifiers rule (this is the being a glass cannon rule):
	if the global defender weapon is the glass cannon:
		say " + 3 (you are a glass cannon)[run paragraph on]";
		increase the to-hit modifier by 3.		

Chance to win rule (this is the CTW glass cannon bonus rule):
	if the global defender weapon is the glass cannon:
		increase the chance-to-win by 3.

After readying the glass cannon:
	say "You feel fragile.";
	now permanent health of player is permanent health of the player divided by 2;
	now health of the player is health of the player divided by 2;
	if player is killed:
		end the story saying "You were a little too fragile for that.".

An aftereffects rule (this is the glass cannon shatters when used to parry rule):
	if the global defender weapon is the glass cannon:
		if the global defender is at parry and the final damage is 0:
			say "The impact shatters the glass cannon.";
			remove the glass cannon from play.

The special weapon info of the glass cannon is "; makes you easier to hit; halves your health[run paragraph on]".

Section - Robe of the Dead Mage

[Concentration not broken on hit; damage increased by 33% per point of concentration.]

The robe of the dead mage is an epic shirt.
The robe of the dead mage is magical.
The material of the robe of the dead mage is cloth.
The indefinite article of the robe of the dead mage is "the".

The description of the robe of the dead mage is "Dominique, marquis of Savon, one of the great mages of his generation, was so fed up with losing his concentration when he was hit that he developed this robe. When the wearer is damaged in combat, he will not lose his concentration; but the protection comes from his life force, and the damage dealt to him is increased by 25% for every level of concentration. People say that nobody ever died with as much concentration as Dominique.".

Last calculate the final damage rule (this is the robe of the dead mage damage rule):
	if global defender wears the robe of the dead mage:
		if concentration of the global defender is greater than 0:
			if concentration of the global defender is 1:
				say " + 25% (robe of the dead mage)[run paragraph on]";
				increase final damage by final damage divided by 4;
			if concentration of the global defender is 2:
				say " +50% (robe of the dead mage)[run paragraph on]";
				increase final damage by final damage divided by 2;		
			if concentration of the global defender is 3:
				say " + 75% (robe of the dead mage)[run paragraph on]";
				let n be final damage divided by 4;
				now final damage is final damage times 2;
				decrease final damage by n;
			if concentration of the global defender is 4:
				say " + 100% (robe of the dead mage)[run paragraph on]";
				now final damage is final damage times 2.

An attack modifiers rule (this is the robe of the dead mage protects you rule):
	if the global defender wears the robe of the dead mage:
		say " - 1 (robe of the dead mage)[run paragraph on]";
		decrease the to-hit modifier by 1.		

The alternative lose concentration when hit rule is listed instead of the lose concentration when hit rule in the aftereffects rules.

An aftereffects rule (this is the alternative lose concentration when hit rule):
	unless global defender wears the robe of the dead mage:
		if the final damage is greater than 0 and the global defender is alive, let the global defender lose concentration.

A standard AI action select rule (this is the robe of the dead mage attack select rule):
	choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
	if global defender wears the robe of the dead mage:
		decrease the Weight entry by the concentration of the global defender.


Section - Essence of Addiction

The essence of addiction is an epic essence. The indefinite article is "the".
The essence of addiction is magical.
The essence of addiction is iron.

The description of the essence of addiction is "This small metal bottle contains the magical essence of addiction, distilled from the brain of a ment user. When inhaled, it greatly increases you addiction to ment -- increasing both the positive effects of a high and the negative effects of a low.".

Carry out inhaling the essence of addiction:
	say " You feel very [if ment timer is less than 1]low[otherwise]high[end if]!";
	increase ment addiction by 2.


Section - Rod of the Master Builder

The rod of the master builder is an epic thing.
The rod of the master builder is barren.
The rod of the master builder is stone.

The description of the rod of the master builder is "This powerful artefact looks like a smooth tube of white stone. It can be used to [italic type]dig[roman type] new tunnels and [italic type]collapse[roman type] old passages; and it also allows its possessor to walk away from combat in relative safety.".

The rod of the master builder is a digging tool.
The rod of the master builder is a collapsing tool.

An attack modifiers rule (this is the rod of master builder attack modifiers rule):
	if the global defender is the player and the player has the rod of the master builder:
		if the player is retreater or the player is runner:
			say " - 2 (rod of the master builder)[run paragraph on]";
			decrease the to-hit modifier by 2.

Last calculate the final damage rule (this is the rod of master builder damage modifiers rule):
	if the global defender is the player and the player has the rod of the master builder:
		if the player is retreater or the player is runner:
			say " - 50% (rod of the master builder)[run paragraph on]";
			now final damage is final damage divided by 2.

Instead of readying the rod of the master builder:
	say "It is not weapon. You can use it without readying it.".
			
Section - Suit of dragon armour

The suit of dragon armour is an epic suit.
Suit of dragon armour is magical.
Suit of dragon armour is dragon skin.
Understand "armor" as the suit of dragon armour.

[The difficulty level of suit of dragon armour is 3.]

The description of the suit of dragon armour is "This lovely suit has been made of dragon leather, the most durable and most magical substance known to man. It protects the wearer against heat and most kinds of damage, but continuously drains his or her health. Use with extreme caution.".
			
Heat resistance rule (this is the dragon armour heat resistance rule):
	if test subject is wearing the suit of dragon armour:
		increase temp-heat by 4.			

[The internal heat of the suit of dragon armour is 4.]

A damage modifiers rule (this is the dragon armour damage modifiers rule):
	if the global defender is wearing the suit of dragon armour:
		if the main actor is not undead:
			say " - 4 (dragon armour)[run paragraph on]";
			decrease the damage modifier by 4;
		otherwise:
			say " - 2 (dragon armour)[run paragraph on]";
			decrease the damage modifier by 2.

A physical damage reduction rule (this is the dragon armour damage reduction rule):
	if the test subject is wearing the dragon armour:
		increase the pdr by 2;
		if the test subject is not undead:
			increase the pdr by 2.

[Before printing the name of suit of dragon armour:
	now not-mentioning-hotness is true.

After printing the name of suit of dragon armour:
	now not-mentioning-hotness is false.]

A standard AI action select rule (this is the dragon armour concentration select rule):
	choose row with an Option of the action of the global attacker concentrating in the Table of AI Combat Options;
	if the global defender is wearing the suit of dragon armour:
		increase the Weight entry by 4.

Every turn when the main actor wears the dragon armour:
	if the health of the main actor is greater than 0:
		if the main actor is not undead or a random chance of 1 in 3 succeeds:
			if a random chance of 1 in 2 succeeds:
				decrease the health of the main actor by 1;
		if the health of the main actor is less than 1:
			end the game saying "The dragon armour has claimed your life.".

Chapter - Powders

Section - Ment

A package of ment is a kind of thing. The plural of package of ment is packages of ment. The description of a package of ment is "Carefully folded in paper, this is just enough ment to get you pumped up for combat. You could snort it whenever you wish[if the ment addiction is 0] -- though you are a little hesitant to start your habit again[end if].".
A package of ment is paper.

There are ten packages of ment. The player carries three packages of ment.

The ment addiction is a number that varies. The ment addiction is 0.

To decide which number is the ment bonus:
	let n be ment addiction;
	decide on n.

The ment timer is a number that varies. The ment timer is 0.

Every turn when the main actor is the player:
	if the ment timer is greater than 0:
		decrease the ment timer by 1;
		if the ment timer is 0:
			say "As suddenly as it began, the rush given by the [bold type]ment[roman type] falls away. You are left feeling empty and only half alive.".

The OD timer is a number that varies. The OD timer is 0.

Every turn when the main actor is the player:
	if the OD timer is greater than 0:
		decrease the OD timer by 1;
		if the OD timer is 7:
			say "Your breathing is becoming heavy and irregular.";
		if the OD timer is 3:
			say "Respiration becomes more difficult by the second. Your heartbeat feels very irregular.";
		if the OD timer is 0:
			end the game saying "You OD'ed.".

An ability test rule (this is the ment ability bonus rule):
	if the test subject is the player:
		if ment timer is greater than 0:
			increase test score by ment bonus;
			say " + [ment bonus] (ment)[run paragraph on]".

An attack modifiers rule (this is the ment attack and defence bonus rule):
	if the global attacker is the player:
		if ment timer is greater than 0:
			if the numbers boolean is true, say " + [ment bonus] (ment)[run paragraph on]";
			increase the to-hit modifier by ment bonus;
	if the global defender is the player:
		if ment timer is greater than 0:
			if the numbers boolean is true, say " - [ment bonus] (your defence increased by ment)[run paragraph on]";
			decrease the to-hit modifier by ment bonus.
			
Chance to win rule (this is the CTW ment penalty rule): [To make sure the AI correctly guesses its chance to win.]
	if the ment timer is greater than 0:
		decrease the chance-to-win by ment bonus.			

A damage modifiers rule (this is the ment damage bonus rule):
	if the global attacker is the player:
		if ment timer is greater than 0:
			if the numbers boolean is true, say " + [ment bonus] (ment)[run paragraph on]";
			increase the damage modifier by ment bonus;
	if the global defender is the player:
		if ment timer is greater than 0:
			if the numbers boolean is true, say " - [ment bonus] (ment makes you shrug off damage)[run paragraph on]";
			decrease the damage modifier by ment bonus.

An attack modifiers rule (this is the feeling down attack penalty rule):
	if the global attacker is the player:
		if the ment addiction is greater than 0:
			if the ment timer is 0:
				if the numbers boolean is true, say " - [ment addiction] (feeling down)[run paragraph on]";
				decrease the to-hit modifier by ment addiction.	
				
An ability test rule (this is the feeling down ability penalty rule):
	if the test subject is the player:
		if the ment addiction is greater than 0:
			if the ment timer is 0:
				decrease test score by ment addiction;
				say " - [ment addiction] (feeling down)[run paragraph on]".				
				

Snorting is an action applying to one carried thing. Understand "snort [thing]" and "sniff [thing]" as snorting. Understand "use [package of ment]" as snorting.

Check snorting:
	if the noun is an essence:
		try inhaling the noun instead;
	otherwise:
		if the noun is not a package of ment:
			take no time;
			say "You cannot snort that." instead.

Check snorting a package of ment when hate is present:
	unless player is hidden:
		take no time;
		say "There is absolutely no way you could pull that off in a combat situation. The ment would get spilled everywhere." instead.

Carry out snorting a package of ment:
	if the ment addiction is 0 or at least three packages of ment are on-stage:
		say "You take a small mirror, a razor and a straw from one of your pockets, and carefully cut the ment on the surface of the mirror. The light blue powder is looking very good. Using the straw, you manage to get almost all of it in your nose. You inhale sharply a few times -- and feel the ment do its awesome work.[paragraph break]Everything becomes clear, sharp, easy. You feel strong. You feel focused.";
	otherwise:
		say "You repeat the ritual: cutting, forming into a line, snorting through the straw, inhaling sharply. The ment kicks in immediately.";
	have the ment kick in.

To have the ment kick in:
	increase the ment addiction by 1;
	[unless ment timer is 0:
		if a random chance of 1 in 2 succeeds:
			if the OD timer is 0:
				now the OD timer is 12;
			otherwise:
				end the game saying "You OD'ed.";]
	now the ment timer is a random number between 10 and 15;
	remove the noun from play.
	


Status rule (this is the ment status rule):
	if ment timer is greater than 0:
		say "You are under the influence of [bold type]ment[roman type]: +[ment bonus] attack, +[ment bonus] damage, -[ment bonus] enemy damage, +[ment bonus] defence, +[ment bonus] to all abilities.[line break][run paragraph on]";
	if ment timer is 0 and ment addiction is greater than 0:
		say "You feel [bold type]down[roman type]: -[ment addiction] attack, -[ment addiction] to all abilities[line break][run paragraph on]".

Instead of eating a package of ment (this is the ment cannot be eaten rule):
	take no time;
	say "Ment has to be taken through the nose, not the mouth. Try snorting it.".


Kerkerkruip Items ends here.
